package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Poblacion;

import java.util.ArrayList;

public class PoblacionController {

    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "poblaciones";

    public PoblacionController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key autoincrement, " +
                        "nombre_poblacion text, " +
                        "primer_hora_limite text, " +
                        "segunda_hora_limite text, " +
                        "primer_dia_cobro text, " +
                        "monto_multa text, " +
                        "grupo text, " +
                        "fecha_inicio text, " +
                        "ruta_id text, " +
                        "created_at text, " +
                        "updated_at text) "
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);
    }

    public void drop(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);
    }

    public boolean tablaExiste() {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + NOMBRE_TABLA+ "'", null);

        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }


    public int eliminar(Poblacion poblacion) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        String[] argumentos = {String.valueOf(poblacion.getId())};
        return db.delete(NOMBRE_TABLA, "id = ?", argumentos);
    }

    public void create(){

    }

    public long nueva(Poblacion poblacion) {
        // writable porque vamos a insertar
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from poblaciones where poblaciones.id = " + poblacion.getId(), null);

        if(cursor.moveToFirst()){
            return 0;
        }
        else{
            ContentValues valoresParaInsertar = new ContentValues();
            valoresParaInsertar.put("id", poblacion.getId());
            valoresParaInsertar.put("nombre_poblacion", poblacion.getNombre_poblacion());
            valoresParaInsertar.put("primer_hora_limite", poblacion.getPrimer_hora_limite());
            valoresParaInsertar.put("segunda_hora_limite", poblacion.getSegunda_hora_limite());
            valoresParaInsertar.put("primer_dia_cobro", poblacion.getPrimer_dia_cobro());
            valoresParaInsertar.put("monto_multa", poblacion.getMonto_multa());
            valoresParaInsertar.put("grupo", poblacion.getGrupo());
            valoresParaInsertar.put("fecha_inicio", poblacion.getFecha_inicio());
            valoresParaInsertar.put("ruta_id", poblacion.getRuta_id());
            valoresParaInsertar.put("created_at", poblacion.getCreated_at());
            valoresParaInsertar.put("updated_at", poblacion.getUpdated_at());
            return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);

        }

    }

    public void truncate(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key autoincrement, " +
                        "nombre_poblacion text, " +
                        "primer_hora_limite text, " +
                        "segunda_hora_limite text, " +
                        "primer_dia_cobro text, " +
                        "monto_multa text, " +
                        "grupo text, " +
                        "fecha_inicio text, " +
                        "ruta_id text, " +
                        "created_at text, " +
                        "updated_at text) "
                , NOMBRE_TABLA);

        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

        Log.d("TRUNCATE",NOMBRE_TABLA);
    }

    public ArrayList<Poblacion> obtener() {
        ArrayList<Poblacion> poblaciones = new ArrayList<>();
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String[] columnasAConsultar = {"id", "nombre_poblacion", "primer_hora_limite", "segunda_hora_limite",
                "primer_dia_cobro", "monto_multa", "grupo", "fecha_inicio","ruta_id","created_at", "updated_at"};
        Cursor cursor = db.query(
                NOMBRE_TABLA,
                columnasAConsultar,
                null,
                null,
                null,
                null,
                "id DESC"
        );

        if (cursor == null) {

            return poblaciones;

        }
        if (!cursor.moveToFirst()) return poblaciones;

        do {
            String id = cursor.getString(0);
            String nombre_poblacion = cursor.getString(1);
            String primer_hora_limite = cursor.getString(2);
            String segunda_hora_limite = cursor.getString(3);
            String primer_dia_cobro = cursor.getString(4);
            String monto_multa = cursor.getString(5);
            String grupo = cursor.getString(6);
            String fecha_inicio = cursor.getString(7);
            String ruta_id = cursor.getString(8);
            String created_at = cursor.getString(9);
            String updated_at = cursor.getString(10);

            Poblacion poblacionObtenidaDeBD = new Poblacion(id, nombre_poblacion, primer_hora_limite, segunda_hora_limite, primer_dia_cobro, monto_multa, grupo,
                    fecha_inicio, ruta_id, created_at, updated_at);
            poblaciones.add(poblacionObtenidaDeBD);
        } while (cursor.moveToNext());

        cursor.close();
        return poblaciones;
    }

    public ArrayList<Poblacion> getPoblaciones(String pid) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM poblaciones WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{pid});
        ArrayList<Poblacion> poblaciones = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(0);
                String poblacion = cursor.getString(1);
                String phl = cursor.getString(2);
                String shl = cursor.getString(3);
                String pdc = cursor.getString(4);
                String mm = cursor.getString(5);
                String grupo = cursor.getString(6);
                String fi = cursor.getString(7);
                String rid = cursor.getString(8);
                String ca = cursor.getString(9);
                String ua = cursor.getString(10);

                poblaciones.add(new Poblacion(
                        id,
                        poblacion,
                        phl,
                        shl,
                        pdc,
                        mm,
                        grupo,
                        fi,
                        rid,
                        ca,
                        ua
                ));
            } while (cursor.moveToNext());
        }
        return poblaciones;
    }

    public ArrayList<Poblacion> getPoblaciones() {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM poblaciones";
        Cursor cursor = db.rawQuery(q, new String[]{});
        ArrayList<Poblacion> poblaciones = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(0);
                String poblacion = cursor.getString(1);
                String phl = cursor.getString(2);
                String shl = cursor.getString(3);
                String pdc = cursor.getString(4);
                String mm = cursor.getString(5);
                String grupo = cursor.getString(6);
                String fi = cursor.getString(7);
                String rid = cursor.getString(8);
                String ca = cursor.getString(9);
                String ua = cursor.getString(10);

                poblaciones.add(new Poblacion(
                        id,
                        poblacion,
                        phl,
                        shl,
                        pdc,
                        mm,
                        grupo,
                        fi,
                        rid,
                        ca,
                        ua
                ));
            } while (cursor.moveToNext());
        }
        return poblaciones;
    }

    public ArrayList<Poblacion> getPoblacionesRuta(String ruta_id) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM poblaciones WHERE ruta_id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{ruta_id});
        ArrayList<Poblacion> poblaciones = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(0);
                String poblacion = cursor.getString(1);
                String phl = cursor.getString(2);
                String shl = cursor.getString(3);
                String pdc = cursor.getString(4);
                String mm = cursor.getString(5);
                String grupo = cursor.getString(6);
                String fi = cursor.getString(7);
                String rid = cursor.getString(8);
                String ca = cursor.getString(9);
                String ua = cursor.getString(10);

                poblaciones.add(new Poblacion(
                        id,
                        poblacion,
                        phl,
                        shl,
                        pdc,
                        mm,
                        grupo,
                        fi,
                        rid,
                        ca,
                        ua
                ));
            } while (cursor.moveToNext());
        }
        return poblaciones;
    }

    public String getNombrePoblacion(String id) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT nombre_poblacion FROM poblaciones WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{id});

        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return "";
    }
}
